
#include <unistd.h>
#include <gtk/gtk.h>
#include "main.h"
#include "if.h"


/* Function lookup_widget:
 *
 * Returns a pointer to a widget found by his name
 * (from glade)
*/
GtkWidget* if_lookup_widget(GtkWidget *widget, const gchar *widget_name)
{
	GtkWidget *parent, *found_widget;

	for (;;)
	{
		if (GTK_IS_MENU (widget))
			parent = gtk_menu_get_attach_widget (GTK_MENU (widget));
		else
			parent = widget->parent;
		if (parent == NULL)
			break;
		widget = parent;
	}

	found_widget = (GtkWidget*) gtk_object_get_data (GTK_OBJECT (widget), widget_name);
	if (!found_widget)
		g_warning ("Widget not found: %s", widget_name);
	return found_widget;
}



/* Function if_treat_pending_events:
 *
 * Loop through the events to empty interface waiting events 
*/
void if_treat_pending_events()
{
	while (gtk_events_pending())
	{
		gtk_main_iteration();
		usleep(100);
	}
}
