

#include <gtk/gtk.h>
#include "if_about.h"
#include "main.h"


/* This is our private functions */
static GtkWidget *about_window = NULL;
static GtkWidget *ok_button = NULL;
static GtkWidget *box1 = NULL;
static GtkWidget *box2 = NULL;
static GtkWidget *table = NULL;
static GtkWidget *text = NULL;



/* This is our private widgets */
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);



/* Function if_about:
 *
 * Creates and displays the about window
*/
void if_about()
{
	if (about_window)
		return;

	/* create a new window */
	about_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(about_window), "About GTK Rio Util");

	gtk_signal_connect(GTK_OBJECT(about_window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(about_window), "destroy", GTK_SIGNAL_FUNC(delete_event), NULL);

	/* Sets the border width of the window. */
	gtk_container_set_border_width(GTK_CONTAINER(about_window), 10);

	box1 = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER (about_window), box1);
	gtk_widget_show(box1);

	box2 = gtk_vbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(box2), 10);
	gtk_box_pack_start(GTK_BOX(box1), box2, TRUE, TRUE, 0);
	gtk_widget_show(box2);

	table = gtk_table_new(2, 1, FALSE);
	gtk_table_set_row_spacing(GTK_TABLE(table), 0, 2);
	gtk_box_pack_start(GTK_BOX(box2), table, TRUE, TRUE, 0);
	gtk_widget_show(table);


	/* Create the GtkText widget */
	text = gtk_label_new(
		"GTK Rio Util v" GTKRIOUTIL_VERSION "\n(c) 2001 Christophe Boyanique\ntof@raceme.org\n\n"
		"This program is licensed under the terms of the GNU General Public License version 2\n"
		"(http://www.gnu.org)\n\n"
		"Thanks to Alcove (http://www.alcove.com) for free software time\n\n"
		"This program uses the rioutil/libpdmp library\n(http://rioutil.sourceforge.net)\n"
	);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);

	/* Creates a new button with the label "Ok". */
	ok_button = gtk_button_new_with_label ("Ok");

	/* When the button receives the "clicked" signal, it will call the
	 * function hello() passing it NULL as its argument.  The hello()
	 * function is defined above. */
	gtk_signal_connect(GTK_OBJECT(ok_button), "clicked", GTK_SIGNAL_FUNC(delete_event), NULL);

	/* This will cause the window to be destroyed by calling
	 * gtk_widget_destroy(window) when "clicked".  Again, the destroy
	 * signal could come from here, or the window manager. */
	gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked",
		GTK_SIGNAL_FUNC (gtk_widget_destroy),
		GTK_OBJECT(about_window));

	gtk_table_attach(GTK_TABLE(table), ok_button, 0, 1, 1, 2,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);

	/* The final step is to display this newly created widget. */
	gtk_widget_show(ok_button);


	/* and the window */
	gtk_widget_show(about_window);

}



/* Function delete_event:
 *
 * This function deals with the destruction of the window. The
 * pointer is set to NULL and the window is really destroyed
 * (FALSE return)
*/
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	about_window = NULL;

	return (FALSE);
}
