

#include <gtk/gtk.h>
#include "if_blockbox.h"


/* This is our private functions */
static GtkWidget *window = NULL;
static GtkWidget *text = NULL;
static GtkWidget *box1 = NULL;
static GtkWidget *box2 = NULL;

/* This is our private widgets */
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);



/* Function if_about:
 *
 * Creates and displays the about window
*/
void if_blockbox_on(GtkWidget *parent, char *title, char * message)
{
	if (window)
		return;

	/* create a new window */
	window = gtk_window_new(GTK_WINDOW_POPUP);
	gtk_window_set_title(GTK_WINDOW(window), title);

	if (parent)
	{
/*		gtk_widget_set_parent_window(window, GTK_WINDOW(parent));*/
		gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
	}
	else
		gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);

	gtk_window_set_modal(GTK_WINDOW(window), (TRUE));

	gtk_signal_connect(GTK_OBJECT(window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(delete_event), NULL);

	/* Sets the border width of the window. */
	gtk_container_set_border_width(GTK_CONTAINER(window), 10);

	box1 = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER (window), box1);
	gtk_widget_show(box1);

	box2 = gtk_vbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(box2), 10);
	gtk_box_pack_start(GTK_BOX(box1), box2, TRUE, TRUE, 0);
	gtk_widget_show(box2);

	/* Create the GtkLabel widget */
	text = gtk_label_new(message);
	gtk_box_pack_start(GTK_BOX(box2), text, TRUE, TRUE, 0);
	gtk_widget_show(text);

	/* and the window */
	gtk_widget_show(window);

}



void if_blockbox_off()
{
	if (! window)
		return;

	gtk_widget_destroy(text);
	text = NULL;
	gtk_widget_destroy(box2);
	box2 = NULL;
	gtk_widget_destroy(box1);
	box1 = NULL;
	gtk_widget_destroy(window);
	window = NULL;
}



/* Function delete_event:
 *
 * This function deals with the destruction of the window. The
 * pointer is set to NULL and the window is really destroyed
 * (FALSE return)
*/
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	window = NULL;

	return (FALSE);
}
