
#include <stdio.h>
#include <gtk/gtk.h>
#include "if_about.h"
#include "main.h"
#include "rio.h"


/* This is our private functions */
static GtkWidget *infos_window = NULL;
static GtkWidget *ok_button = NULL;
static GtkWidget *apply_button = NULL;
static GtkWidget *box1 = NULL;
static GtkWidget *box2 = NULL;
static GtkWidget *table = NULL;
static GtkWidget *table_button = NULL;
static GtkWidget *text = NULL;



/* This is our private widgets */
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data);



/* Function if_about:
 *
 * Creates and displays the about window
*/
void if_infos()
{
	char buf[128];
	char buf2[128];
	int space_total, space_used, space_free, space_percent_used, space_percent_free, time_usage;
	int i;
	const char *p;
	GtkAdjustment *volume_adj;

	if (infos_window)
		return;

	/* create a new window */
	infos_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(infos_window), "Player informations");

	gtk_signal_connect(GTK_OBJECT(infos_window), "delete_event", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect(GTK_OBJECT(infos_window), "destroy", GTK_SIGNAL_FUNC(delete_event), NULL);

	/* Sets the border width of the window. */
	gtk_container_set_border_width(GTK_CONTAINER(infos_window), 10);

	box1 = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER (infos_window), box1);
	gtk_widget_show(box1);

	box2 = gtk_vbox_new(FALSE, 10);
	gtk_container_set_border_width(GTK_CONTAINER(box2), 10);
	gtk_box_pack_start(GTK_BOX(box1), box2, TRUE, TRUE, 0);
	gtk_widget_show(box2);

	table = gtk_table_new(13, 2, FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(table), 2);
	gtk_table_set_col_spacings(GTK_TABLE(table), 10);
	gtk_box_pack_start(GTK_BOX(box2), table, TRUE, TRUE, 0);
	gtk_widget_show(table);


	/* Firmware version */
	text = gtk_label_new("Firmware:");
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 0, 0);
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_widget_show(text);
	sprintf(buf, "v%.2f", rio_get_version());
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 0, 1, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Player Type */
	text = gtk_label_new("Type:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	switch (rio_get_type())
	{
		case 0:
			strcpy(buf, "Rio 600");
			break;
		case 1:
			strcpy(buf, "Rio 800");
			break;
		case 2:
			strcpy(buf, "PsaPlay");
			break;
		default:
			break;
	}
	sprintf(buf, "%s", buf);
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 1, 2, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Player Name */
	text = gtk_label_new("Name:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 2, 3, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	sprintf(buf, "%s", rio_get_name());
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 2, 3, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Number of memory devices */
	text = gtk_label_new("Memory devices:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 3, 4, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	sprintf(buf, "%d", rio_get_num_memdev());
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 3, 4, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Calculate total space */
	space_used = rio_get_usage();
	space_free = rio_get_free();
	space_total = space_used + space_free;
	space_percent_used = (int)(  100 * ((double)space_used) / ((double)space_total)      );
	space_percent_free = (int)(  100 * ((double)space_free) / ((double)space_total)      );
	time_usage = rio_get_time();
	if (time_usage < 60)
		sprintf(buf2, ":%2d", time_usage);
	else if (time_usage < 3600)
		sprintf(buf2, ":%d:%02d", time_usage/60, time_usage%60);
	else
		sprintf(buf2, "%d:%02d:%02d", time_usage/3600, (time_usage%3600)/60, (time_usage%3600)%60);

	/* Total space */
	text = gtk_label_new("Total space:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 4, 5, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	if (space_used < 1024)
		sprintf(buf, "%d", space_total);
	else if (space_total < 1024*1024)
		sprintf(buf, "%d Kb", space_total/1024);
	else
		sprintf(buf, "%d Mb", space_total/(1024*1024));
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 4, 5, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Used space */
	text = gtk_label_new("Used space:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 5, 6, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	if (space_used < 1024)
		sprintf(buf, "%d (%d%%, %s)", space_used, space_percent_used, buf2);
	else if (space_used < 1024*1024)
		sprintf(buf, "%.2f Kb (%d%%, %s)", ((double)space_used)/((double)1024), space_percent_used, buf2);
	else
		sprintf(buf, "%.2f Mb (%d%%, %s)", ((double)space_used)/((double)1024*1024), space_percent_used, buf2);
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 5, 6, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Free space */
	text = gtk_label_new("Free space:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 6, 7, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	if (space_free < 1024)
		sprintf(buf, "%d (%d%%)", space_free, space_percent_free);
	else if (space_free < 1024*1024)
		sprintf(buf, "%.2f Kb (%d%%)", ((double)space_free)/((double)1024), space_percent_free);
	else
		sprintf(buf, "%.2f Mb (%d%%)", ((double)space_free)/((double)1024*1024), space_percent_free);
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 6, 7, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Volume */
	text = gtk_label_new("Volume:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 7, 8, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	volume_adj = (GtkAdjustment *)gtk_adjustment_new(rio_get_volume(), 0, 21, 1, 1, 1);
	text = gtk_hscale_new(volume_adj);
	gtk_scale_set_digits(GTK_SCALE(text), 0);
	gtk_scale_set_value_pos(GTK_SCALE(text), GTK_POS_RIGHT);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 7, 8, GTK_FILL, 0, 0, 0);
	gtk_widget_show(text);


	/* Equaliser state */
	text = gtk_label_new("Equaliser:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 8, 9, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	p = rio_get_eq_state_name();
	if (p)
		strcpy(buf, p);
	else
		sprintf(buf, "%d", rio_get_eq_state());
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 8, 9, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Light state */
	text = gtk_label_new("Light:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 9, 10, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	p = rio_get_light_state_name();
	if (p)
		strcpy(buf, p);
	else
		sprintf(buf, "%d", rio_get_light_state());
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 9, 10, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Loop state */
	text = gtk_label_new("Loop:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 10, 11, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	p = rio_get_rep_state_name();
	if (p)
		strcpy(buf, p);
	else
		sprintf(buf, "%d", rio_get_rep_state());
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 10, 11, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Contrast */
	text = gtk_label_new("Contrast:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 11, 12, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	sprintf(buf, "%d", rio_get_contrast());
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 11, 12, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);


	/* Playlist */
	text = gtk_label_new("Selected playlist:");
	gtk_misc_set_alignment(GTK_MISC(text), 1.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 0, 1, 12, 13, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);
	i = rio_get_playlist();
	if (i > 0)
		sprintf(buf, "%d", rio_get_playlist());
	else
		strcpy(buf, "None");
	text = gtk_label_new(buf);
	gtk_misc_set_alignment(GTK_MISC(text), 0.0, 0.5);
	gtk_table_attach(GTK_TABLE(table), text, 1, 2, 12, 13, GTK_EXPAND | GTK_SHRINK | GTK_FILL, GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(text);







	table_button = gtk_table_new(1, 2, FALSE);
	gtk_table_set_row_spacings(GTK_TABLE(table_button), 5);
	gtk_table_set_col_spacings(GTK_TABLE(table_button), 5);
	gtk_box_pack_start(GTK_BOX(box2), table_button, TRUE, TRUE, 0);
	gtk_widget_show(table_button);



	/* Creates a new button with the label "Ok". */
	ok_button = gtk_button_new_with_label ("Ok");
	gtk_signal_connect(GTK_OBJECT(ok_button), "clicked", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect_object(GTK_OBJECT(ok_button), "clicked",
		GTK_SIGNAL_FUNC (gtk_widget_destroy),
		GTK_OBJECT(infos_window));
	gtk_table_attach(GTK_TABLE(table_button), ok_button, 0, 1, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(ok_button);


	/* Creates a new button with the label "Apply". */
	apply_button = gtk_button_new_with_label ("Apply");
	gtk_widget_set_sensitive(GTK_WIDGET(apply_button), FALSE);
	gtk_signal_connect(GTK_OBJECT(apply_button), "clicked", GTK_SIGNAL_FUNC(delete_event), NULL);
	gtk_signal_connect_object(GTK_OBJECT(apply_button), "clicked",
		GTK_SIGNAL_FUNC (gtk_widget_destroy),
		GTK_OBJECT(infos_window));
	gtk_table_attach(GTK_TABLE(table_button), apply_button, 1, 2, 0, 1,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL,
		GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, 0);
	gtk_widget_show(apply_button);

	/* and the window */
	gtk_widget_show(infos_window);

}



/* Function delete_event:
 *
 * This function deals with the destruction of the window. The
 * pointer is set to NULL and the window is really destroyed
 * (FALSE return)
*/
static gint delete_event(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	infos_window = NULL;

	return (FALSE);
}
