/*
  (c) 2001 Nathan Hjelm <hjelmn@unm.edu>

  v0.4.1

  Prototypes driver functions.
*/

#include "config.h"
#include "rio-cpp.h"

#if defined(WITH_USBDEVFS)

#include "usbdevfs.h"

#elif defined(__MacOSX__)

#include "macosx.h"

#elif defined(WITH_LIBUSB)

#if defined (__cplusplus)
extern "C" {
#endif

#include <usb.h>

#define usb_claiminterface usb_claim_interface
#define usb_releaseinterface usb_release_interface

int usb_close(struct usbdevice *);

#if defined (__cplusplus)
}
#endif

#else

#if defined (__cplusplus)
extern "C" {
#endif

int usb_claiminterface(struct usbdevice *, int);
int usb_releaseinterface(struct usbdevice *, int);

int usb_close(struct usbdevice *);

#if defined (__cplusplus)
}
#endif

#endif

#if defined (__cplusplus)
extern "C" {
#endif

struct usbdevice *rio_usb_open(void);

int read_bulk(struct usbdevice *dev, unsigned char *buffer, u_int32_t size);
int write_bulk(struct usbdevice *dev, unsigned char *buffer, u_int32_t size);
int control_msg(struct usbdevice *dev, u_int8_t direction, u_int8_t request, u_int16_t value,
		u_int16_t index, u_int16_t length, unsigned char *buffer);

#if defined (__cplusplus)
}
#endif
