#ifndef RIO_STRUCT_H
#define RIO_STRUCT_H
/*
 * memory structure for pmp600
 * this has only been tested with internal mem :/
 *
 */

#include <sys/types.h>
#include <stdlib.h>

typedef struct{
  u_int32_t foo[4];
  u_int32_t size;
  u_int32_t used;
  u_int32_t free;
  u_int32_t system;
  
  u_int32_t foobar[8];
  
  u_int8_t name[64];
  
  u_int8_t unk[128];
} rio_mem;

/*
 * structure for a info header on the rio
 *
 */
typedef struct{
  /* 0x0000 - 0x000f */
  u_int32_t file_no; /* set by rio ??? */
  /* 
     This appears to be a pointer to the start of the file.
     If it is left as 0x00000000 then the Rio seems to set it,
     but a value *can* be passed in with varying results.
  */
  u_int32_t start;


  u_int32_t size;
  u_int32_t time;

  
  /* 0x0010 - 0x001f */
  /* XXX time_t different sizes on different systems (64 bit on NetBSD/alpha) */
  u_int32_t mod_date; /* given in secs since epoch */

  /*
    So far I have found that this value contains this:
    0x00000001 0x00000010 0x00000100 must be set
    0x00000002 : has bookmark?
    0x00400000 : Name does not display
    0x00000080 : Downloadable
  */
  u_int32_t bits;

  /*
    This value can be set (currently) with the following values
    0x3347504d : MPG3 (MPEG Layer III)
    0x20414d57 : WMA  (Winbloze Media)
    0x504c4341 : ACLP (WAVE)
    0x45564157 : WAVE (Microshaft)
  */
  u_int32_t type; 

  u_int32_t foo3;

  
  /* 0x0020 - 0x002f */
  u_int32_t foo4; /* maybe channels? */
  u_int32_t sample_rate;
  u_int32_t bit_rate; /* it is multiplied by 128 so >> 7 gives value :) */
  u_int32_t foo5;
  
  /* 0x0030 - 0x005f -- usually zeros */
  u_int8_t foobar[48];
  
  /* 0x0060 - 0x007f */
  u_int8_t info0[32];
  
  /* 0x0080 - 0x00b9 */
  u_int8_t info1[64];
  
  /* 0x00c0 - 0x00ff */
  u_int8_t name[64];
  
  /* 0x0100 - 0x013f */
  u_int8_t title[64];
  
  /* 0x0140 - 0x017f */
  u_int8_t artist[64];
  
  /* 0x0180 - 0x01bf */
  u_int8_t album[64];
    
  /* 0x01c0 - ? */
    // TODO -- figure out what is here
  u_int32_t zeros[400];
} rio_file;

#if BYTE_ORDER == BIG_ENDIAN
#if !defined(__FreeBSD__) && !defined(__MacOSX__)
#include <byteswap.h>
#else
#include "rio-bsd.h"
#endif
static rio_file *swap_file(const rio_file *file){
#if defined(__cplusplus)
  rio_file *tmp = new rio_file;
#else
  rio_file *tmp = (rio_file *)malloc(sizeof(rio_file));
#endif

  *tmp = *file;
  
  tmp->file_no     = bswap_32(tmp->file_no);
  tmp->start       = bswap_32(tmp->start);
  tmp->size        = bswap_32(tmp->size);
  tmp->time        = bswap_32(tmp->time);
  tmp->mod_date    = bswap_32(tmp->mod_date);
  tmp->bits        = bswap_32(tmp->bits);
  tmp->foo3        = bswap_32(tmp->foo3);
  tmp->foo4        = bswap_32(tmp->foo4);
  tmp->sample_rate = bswap_32(tmp->sample_rate);
  tmp->bit_rate    = bswap_32(tmp->bit_rate);
  
  return tmp;
}

static rio_mem *swap_mem(const rio_mem *memory){
#if defined(__cplusplus)
  rio_mem *tmp = new rio_mem;
#else
  rio_mem *tmp = (rio_mem *)malloc(sizeof(rio_mem));
#endif

  *tmp = *memory;
  
  tmp->size   = bswap_32(memory->size);
  tmp->used   = bswap_32(memory->used);
  tmp->free   = bswap_32(memory->free);
  tmp->system = bswap_32(memory->system);
  
  return tmp;
}
#endif /* BYTE_ORDER == BIG_ENDIAN */
#endif /* RIO_STRUCT_H */  
  
