/*
  (c) 2001 Nathan Hjelm <hjelmn@unm.edu>

  v0.4.1

  Driver for use with libusb 0.1.3b
*/

#include "driver.h"

#if defined (WITH_LIBUSB) && defined (HAVE_LIBUSB)

#define VENDOR_DIAMOND01  0x045a

#define PRODUCT_RIO600    0x5001
#define PRODUCT_RIO800    0x5002
#define PRODUCT_PSAPLAY   0x5003

struct usbdevice *rio_usb_open(void){
  struct usb_bus *bus = NULL;
  struct usb_device *dev = NULL;

  usb_init();

  usb_find_busses();
  usb_find_devices();

  for (bus = usb_busses ; bus ; bus = bus->next)
    for (dev = bus->devices ; dev ; dev = dev->next){
      if (dev->descriptor.idVendor == VENDOR_DIAMOND01){
	if (dev->descriptor.idProduct == PRODUCT_RIO600)
	  break;
	else if (dev->descriptor.idProduct == PRODUCT_RIO800)
	  break;
	else if (dev->descriptor.idProduct == PRODUCT_PSAPLAY)
	  break;
      }
    }

  if (dev)
    return usb_open(dev);

  return NULL;
}

/* direction is unused  here */
int control_msg(struct usbdevice *dev, u_int8_t direction, u_int8_t request, unsigned short value,
			      unsigned short index, unsigned short length, unsigned char *buffer){

  unsigned char requesttype = 0;
  int ret;

  requesttype = 0x80 | USB_TYPE_VENDOR | USB_RECIP_DEVICE;

  ret = usb_control_msg(dev, requesttype, request, value, index, (char *)buffer, length, 5000);

  if (ret == length)
    return 0;
  else
    return ret;
}

inline int write_bulk(struct usbdevice *dev, unsigned char *buffer, u_int32_t size){
  return usb_bulk_write(dev, 0x2, (char *)buffer, size, 5000);
}

inline int read_bulk(struct usbdevice *dev, unsigned char *buffer, u_int32_t size){
  return usb_bulk_read(dev, 0x82, (char *)buffer, size, 5000);
}

#endif /* WITH_LIBUSB */
