/*
  (c) 2001 Nathan Hjelm <hjelmn@unm.edu>

  v0.4.1

  Driver to go with kernel level rio drivers
*/

#include "driver.h"

int usb_close(struct usbdevice *dev){
  close(dev->fd);
  free(dev);
}

int read_bulk(struct usbdevice *dev, unsigned char *buffer, u_int32_t size){
  if (dev)
    return read(dev->fd, buffer, size);
  else
    return -1;
}

int write_bulk(struct usbdevice *dev, unsigned char *buffer, u_int32_t size){
  if (dev)
    return write(dev->fd, buffer, size);
  else
    return -1;
}

struct usbdevice *rio_usb_open(void){
}

/* no need to mess with interfaces */
int usb_claiminterface(struct usbdevice *dev, int interface){return 0;}
int usb_releaseinterface(struct usbdevice *dev, int interface){return 0;}
