
/*
 * $Id: hexdump.c,v 1.1 2000/09/13 16:54:49 jasper Exp $
 *
 * Pretty print a buffer with ASCII.
 *
 */

#include "hexdump.h"

/*
  pretty_print_block:
    Function takes in an output stream, character
  buffer and buffer length and prints out the buffer
  in an easier to read format.
*/
void pretty_print_block(ostream &errorO, unsigned char *b, int len){
  int x, y, indent, count = 0;
  
  indent = 16; /* whatever */
  
  errorO.form("\n");
  
  while (count < len){
    errorO.form("%04x: ", count); // printf("%04x",count);
    for (x = 0 ; x < indent ; x++){
      errorO.form("%02x ", b[x + count]); // printf("%02x ", b[x + count]);
      if ((x + count + 1) >= len){
	x++;
	for (y = 0 ; y < (indent - x) ; y++)
	  errorO.form("   "); // printf("   ");
	break;
      }
    }
    errorO.form(": "); //printf(": ");
    
    for (x = 0 ; x < indent ; x++){
      if (isprint(b[x + count]))
	errorO.put(b[x + count]); //putchar(b[x + count]);
      else
	errorO.put('.'); //putchar('.');
      
      if ((x + count + 1) >= len){
	x++;
	for (y = 0 ; y < (indent - x) ; y++)
	  errorO.put(' '); //putchar(' ');
	break;
      }
    }
    errorO.put('\n'); //putchar('\n');
    count += indent;
  }
  errorO.put('\n'); //putchar('\n');
}

