#include <string.h>
#include <errno.h>

#include "config.h"

#ifdef HAVE_LIBGEN_H
#include <libgen.h>
#endif

#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>

#include "rio-cpp.h"
#include "rio-bsd.h"
#include "hexdump.h"

/*
  WMAgetInfo:
    Function takes in a file name (WMA) and returns a
  structure with a completed Rio header struct.

  -- This is VERY imcomplete and does not work properly --
*/
Info rioInstance::WMAgetInfo(const char *file_name){
  Info newInfo;
  rio_file *wma_file;
  struct stat statinfo;
  char *tmp1, *tmp2;

  if (stat(file_name, &statinfo) < 0){
    newInfo.data = NULL;
    return newInfo;
  }

  wma_file = new rio_file;
  bzero(wma_file, sizeof(rio_file));
  // It does want the size
  wma_file->size = statinfo.st_size;

  // No mod date on wma
  wma_file->mod_date = 0x00000000;

  tmp1 = new char[strlen(file_name) + 1];
  bzero(tmp1, strlen(file_name) + 1);
  
  strncpy(tmp1, file_name, strlen(file_name));
  tmp2 = basename(tmp1);

  strncpy((char *)wma_file->name , tmp1, (strlen(tmp2) < 64) ? strlen(tmp2) : 63);
  strncpy((char *)wma_file->title, tmp2, (strlen(tmp2) < 64) ? strlen(tmp2) : 63);
  strncpy((char *)wma_file->artist, tmp2, (strlen(tmp2) < 64) ? strlen(tmp2) : 63);
  strncpy((char *)wma_file->album, tmp2, (strlen(tmp2) < 64) ? strlen(tmp2) : 63);

  delete[] tmp1;

  // Don't know about junk here yet
  newInfo.junk = 0;

  // I don't know why!
  //  wma_file->bits = 0x10000b11;
  //  wma_file->type = TYPE_MP3;

  // But this may have somthing to do with it
  //  wma_file->foo3 = 0x21030000;
  //  wma_file->foo3 = 0x00000321;
  wma_file->foobar[0] = 0x01;
 
  newInfo.data = wma_file;

  return newInfo;
}
